### Active Federated Learning

Active Federated Learning is a client selection algorithm, where clients were selected not uniformly at random in each round, but with a probability conditioned on the current model and the data on the client to maximize training efficiency. The objective was to reduce the number of required training iterations while maintaining the same model accuracy. In its implementation in `examples/afl/afl_server.py`, the server overrides `choose_clients()` to implement a custom client selection algorithm, and overrides `weights_aggregated()` to extract additional information from client reports.

```bash
cd examples/client_selection/afl
uv run afl.py -c afl_FashionMNIST_lenet5.yml
```

**Reference:** J. Goetz, K. Malik, D. Bui, S. Moon, H. Liu, A. Kumar. "[Active Federated Learning](https://arxiv.org/abs/1909.12641)," September 2019.

---

### Pisces

Pisces is an asynchronous federated learning algorithm that performs biased client selection based on overall utilities and weighted server aggregation based on staleness. In this example, a client running the Pisces algorithm calculates its statistical utility and report it together with model updates to Pisces server. The server then evaluates the overall utility for each client based on the reported statistical utility and client staleness, and selects clients for the next communication round. The algorithm also attempts to detect outliers via DBSCAN for better robustness.

```bash
cd examples/client_selection/pisces
uv run pisces.py -c pisces_MNIST_lenet5.yml
```

**Reference:** Jiang et al., "[Pisces: Efficient Federated Learning via Guided Asynchronous Training](https://arxiv.org/pdf/2206.09264.pdf)," in Proc. ACM Symposium on Cloud Computing (SoCC), 2022.

---

### Oort

Oort is a federated learning algorithm that performs biased client selection based on both statistical utility and system utility. Originally, Oort is proposed for synchronous federated learning. In this example, it was adapted to support both synchronous and asynchronous federated learning. Notably, the Oort server maintains a blacklist for clients that have been selected too many times (10 by default). If `per_round` / `total_clients` is large, e.g. 2/5, the Oort server may not work correctly because most clients are in the blacklist and there will not be a sufficient number of clients that can be selected.

```bash
cd examples/client_selection/oort
uv run oort.py -c oort_MNIST_lenet5.yml
```

**Reference:** Lai et al., "[Oort: Efficient Federated Learning via Guided Participant Selection](https://www.usenix.org/system/files/osdi21-lai.pdf)," in Proc. USENIX Symposium on Operating Systems Design and Implementation (OSDI), 2021.

---

### Polaris

Polaris is a client selection algorithm for asynchronous federated learning. In this algorithm, clients are selected by balancing between the local device speed and data quality from an optimization perspective. As it does not require extra information beyond local updates, Polaris is compatible with any server aggregation algorithm.

```bash
cd examples/client_selection/polaris
uv run polaris.py -c polaris_FEMNIST_LeNet5.yml
```

!!! tip "Running on macOS"

    This example depends on `cvxopt`, which requires several system-level libraries for compilation:

    ```bash
    brew install suite-sparse gsl glpk fftw
    ```

    If you run into the following error:

    ```
    src/C/umfpack.c:23:10: fatal error: 'umfpack.h' file not found
    ```

    This is because the `UMFPACK` headers from `SuiteSparse` cannot be found. Set the proper environment variables before running:

    ```bash
    export CVXOPT_BUILD_GLPK=0
    export CVXOPT_BUILD_FFTW=0
    export CVXOPT_BUILD_GSL=0
    export CVXOPT_BUILD_DSDP=0
    export CVXOPT_SUITESPARSE_LIB_DIR=/opt/homebrew/opt/suite-sparse/lib
    export CVXOPT_SUITESPARSE_INC_DIR=/opt/homebrew/opt/suite-sparse/include/suitesparse
    ```

!!! warning "Important"
    Make sure you have a valid [Mosek license](https://www.mosek.com/products/academic-licenses/) before proceeding, as the [Mosek optimization solver](https://mosek.com) has been used.

**Reference:** Y. Kang and B. Li, "[Polaris: Accelerating Asynchronous Federated Learning with Client Selection](https://iqua.ece.toronto.edu/papers/ykang-tcc24.pdf)", IEEE Trans. Cloud Computing, vol. 12, no. 2, pp. 446-458, February 2024.
